<?php $__env->startSection('title', 'View Contact Message'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Contact Message</h1>
    <div class="d-flex gap-2">
        <?php if($contactMessage->is_read): ?>
            <form action="<?php echo e(route('admin.contact-messages.markAsUnread', $contactMessage)); ?>" method="POST" class="d-inline">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PATCH'); ?>
                <button type="submit" class="btn btn-warning">
                    <i class="bi bi-envelope"></i> Mark as Unread
                </button>
            </form>
        <?php else: ?>
            <form action="<?php echo e(route('admin.contact-messages.markAsRead', $contactMessage)); ?>" method="POST" class="d-inline">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PATCH'); ?>
                <button type="submit" class="btn btn-success">
                    <i class="bi bi-envelope-check"></i> Mark as Read
                </button>
            </form>
        <?php endif; ?>
        <a href="<?php echo e(route('admin.contact-messages.index')); ?>" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> Back to List
        </a>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <div class="row mb-3">
            <div class="col-md-6">
                <strong>Name:</strong>
                <p><?php echo e($contactMessage->name); ?></p>
            </div>
            <div class="col-md-6">
                <strong>Email:</strong>
                <p><a href="mailto:<?php echo e($contactMessage->email); ?>"><?php echo e($contactMessage->email); ?></a></p>
            </div>
        </div>

        <?php if($contactMessage->subject): ?>
        <div class="mb-3">
            <strong>Subject:</strong>
            <p><?php echo e($contactMessage->subject); ?></p>
        </div>
        <?php endif; ?>

        <div class="mb-3">
            <strong>Message:</strong>
            <p class="mt-2"><?php echo e($contactMessage->message); ?></p>
        </div>

        <div class="row">
            <div class="col-md-6">
                <strong>Status:</strong>
                <p>
                    <span class="badge bg-<?php echo e($contactMessage->is_read ? 'success' : 'warning'); ?>">
                        <?php echo e($contactMessage->is_read ? 'Read' : 'Unread'); ?>

                    </span>
                </p>
            </div>
            <div class="col-md-6">
                <strong>Received:</strong>
                <p><?php echo e($contactMessage->created_at->format('M d, Y h:i A')); ?></p>
            </div>
        </div>

        <hr>

        <form action="<?php echo e(route('admin.contact-messages.destroy', $contactMessage)); ?>" method="POST" onsubmit="return confirm('Are you sure you want to delete this message?');">
            <?php echo csrf_field(); ?>
            <?php echo method_field('DELETE'); ?>
            <button type="submit" class="btn btn-danger">
                <i class="bi bi-trash"></i> Delete Message
            </button>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>




<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Users/sumankc/Desktop/ Websites/ENT Care/resources/views/admin/contact-messages/show.blade.php ENDPATH**/ ?>